%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Approximate the diffusion basis for Example 6.8
% Created by John Harlim
% Last edited: March 26, 2018
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all

load truth2d
N = 10000;          % N= 40000 for the results in the book
x = x(:,1:N)';
dim = 2;
epsilon = 0.0001;
k = 1024;
k2 = 64;
operator = 2;
nvars = 1000;

flag =1; % (=1) automatic epsilon and d, (=2) fixed epsilon and d 

tic
if (flag==1)
    [basis,eigs,epsilon,peqoversample,peq,qest] = VBDM(x,k,k2,nvars,operator);
else
    [basis,eigs,epsilon,peqoversample,peq,qest] = VBDM(x,k,k2,nvars,operator,epsilon,dim);
end
toc

in = [2 19 101 251 501 751];
figure(1)
for i=1:6
    subplot(3,2,i)
    scatter(x(1:20:end,1),x(1:20:end,2),2,basis(1:20:end,in(i)))
    colorbar, caxis([-1 1])
    title(['$\varphi_{',num2str(in(i)-1),'}$'],'interpreter','LaTex')
    if (i>4)
    xlabel('u')
    end
    if (mod(i,2)>0)
        ylabel('v')
    end
end
%print -depsc -r100 basisfun.eps

if (flag==1)
    save diffusionbasisvbdmauto2dv4 basis eigs epsilon peqoversample peq qest x
else
    save diffusionbasis2dv2 basis eigs epsilon peqoversample peq qest x
end
